﻿<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Langs" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ import Namespace="System.Linq" %>
<%@ import Namespace="System" %>
<%@ import Namespace="System.Collections" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Raport sprzedaży wg towarów</title>

    <script runat="server">
		
        public enum SortowanieWedług { WgKoduTowaru, WgNazwyTowaru }

        public class ParametryContext : ContextBase {
            BusinessModule businessmodule;

            public ParametryContext(Context cx)
                : base(cx) {
                businessmodule = BusinessModule.GetInstance(cx.Session);
            }

            SortowanieWedług sortujWedług = SortowanieWedług.WgNazwyTowaru;

            [DefaultWidth(50)]
            [Priority(10)]
            public SortowanieWedług SortujWedług {
                get { return sortujWedług; }
                set {
                    sortujWedług = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            private bool _ignorujZaliczkowe = true;

            [Soneta.Tools.Priority(20)]
            public bool IgnorujZaliczkowe {
                get {
                    return this._ignorujZaliczkowe;
                }
                set {
                    this._ignorujZaliczkowe = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            FeatureDefinition cechaTowaru;

            [Priority(30)]
            [Caption("Cecha towaru")]
            public FeatureDefinition CechaTowaru
            {
                get { return cechaTowaru; }
                set { cechaTowaru = value;
                    OnChanged(EventArgs.Empty);
                    var f = GetListWartoscCechyTowaru() as List<DictionaryItem>;
                    if (f == null)
                    {
                        wartoscCechyTowaru = new DictionaryItem[] { };
                    }
                    else
                    {
                        wartoscCechyTowaru = new DictionaryItem[] { ((List<DictionaryItem>)GetListWartoscCechyTowaru()).FirstOrDefault() };
                    }
                }
            }

            public object GetListCechaTowaru()
            {
                RowCondition rc = new FieldCondition.Equal("TableName", "Towary".TranslateIgnore());
                rc &= new FieldCondition.Equal("TypeNumber", FeatureTypeNumber.String);
                rc &= new FieldCondition.NotEqual("Dictionary", String.Empty);
                return businessmodule.FeatureDefs.ByName[rc];
            }

            DictionaryItem[] wartoscCechyTowaru;

            [Priority(40)]
            [Caption("Wartość cechy towaru")]
            public DictionaryItem[] WartoscCechyTowaru
            {
                get { return wartoscCechyTowaru; }
                set
                {
                    wartoscCechyTowaru = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            public object GetListWartoscCechyTowaru()
            {
                var al = new List<DictionaryItem>();
                if (cechaTowaru == null)
                    return al;
                FeatureDefinition fd = businessmodule.FeatureDefs.ByName["Towary".TranslateIgnore(), cechaTowaru.Name];
                if (fd == null)
                    return al;
                if (fd.DictionaryList != null)
                {
                    foreach (DictionaryItem di in fd.DictionaryList)
                        al.Add(di);
                }
                var s = new string[] { "Caption".TranslateIgnore() };
                var lookupDef = new LookupInfo(new LookupInfo.EnumerableItem("Cechy", al, s));
                return lookupDef;
            }

            public bool IsReadOnlyWartoscCechyTowaru() {
                return cechaTowaru == null;
            }

            string dodatkoweWartosciCechyTowaru = "";                     
        }
        
        static ParametryContext parametry;

        [Context]
        public static ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }


        public class Total {
            readonly Towar towar;
            decimal netto;
            decimal vat;
            decimal brutto;
            Quantity ilosc;
            decimal marza;
            
            SumaPozycjiWorker spw = new SumaPozycjiWorker();
            
            public Total(Towar towar) {
                this.towar = towar;
            }
            
            public void Add(PozycjaDokHandlowego pozycja) {                
                spw.Pozycja = pozycja;
                decimal _wzakupu = pozycja.WartośćWCenieZakupu;
                decimal _wsprzedazy = spw.Netto;
                decimal _marza = _wsprzedazy - _wzakupu;
                marza += _marza;

                netto += spw.Netto;
                vat += spw.Brutto - spw.Netto;
                brutto += spw.Brutto;
                ilosc += pozycja.ZmianaMagazynu.Ilość;                           
            }
            
            public Towar Towar {
                get { return towar; }
            }
            public decimal Netto {
                get { return netto; }
            }
            public decimal VAT {
                get { return vat; }
            }
            public decimal Brutto {
                get { return brutto; }
            }
            public Quantity Ilosc {
                get { return ilosc; }
            }

            public decimal Marza {
                get { return marza; }
            } 
                        
            public string CechaTowaru {
                get {
                    if (Parametry.CechaTowaru == null || towar == null)
                        return "nieokreślona";
                    return towar.Features[Parametry.CechaTowaru].ToString();
                }
            }
        }

        class TowarComparer : IComparer {
            SortowanieWedług sort = SortowanieWedług.WgNazwyTowaru;
            public TowarComparer(SortowanieWedług Sort) {
                sort = Sort;
            }            
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = sort == SortowanieWedług.WgKoduTowaru ? t1.Towar.Kod : t1.Towar.Nazwa;
                string s2 = sort == SortowanieWedług.WgKoduTowaru ? t2.Towar.Kod : t1.Towar.Nazwa;
                if (Parametry.CechaTowaru != null) {
                    string c1 = t1.Towar.Features[Parametry.CechaTowaru].ToString();
                    string c2 = t2.Towar.Features[Parametry.CechaTowaru].ToString();
                    s1 = c1 + ":" + s1;
                    s2 = c2 + ":" + s2;
                }
                return s1.CompareTo(s2);
            }
            
        }
        
        
        void OnContextLoad(Object sender, EventArgs args) {
            Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
            if (pars.Kategoria == KategoriaHandlowa.Sprzedaż) {
                string t = string.Format("Raport sprzedaży wg towarów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            else if (pars.Kategoria == KategoriaHandlowa.Zakup) {
                string t = string.Format("Raport zakupów wg towarów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            else if (pars.Kategoria == KategoriaHandlowa.WydanieMagazynowe) {
                string t = string.Format("Raport wydań wg towarów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            else if (pars.Kategoria == KategoriaHandlowa.PrzyjęcieMagazynowe) {
                string t = string.Format("Raport przyjęć wg towarów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            if (pars.Kontrahent != null)
                ReportHeader.Title += string.Format("|</STRONG>Kontrahent<STRONG>: {0}", pars.Kontrahent.ToString());
            if (pars.Definicja != null)
                ReportHeader.Title += string.Format("|</STRONG>Definicja:<STRONG> {0}", pars.Definicja.ToString());
            if (pars.Okres != Soneta.Types.FromTo.All)
                ReportHeader.Title += string.Format("|</STRONG>Okres:<STRONG> {0}", pars.Okres.ToString());
            if (Parametry.CechaTowaru!= null) {
                ReportHeader.Title += "|Cecha: </STRONG>" + Parametry.CechaTowaru.Name + "<STRONG>";
                Grid.GroupLine = "Wartość cechy " + Parametry.CechaTowaru.Name + ": {0}";
            }            
                        
            Row[] rows = (Row[])dc[typeof(Row[])];
            Hashtable result = new Hashtable();          
                
            if (Parametry.CechaTowaru != null && Parametry.WartoscCechyTowaru != null)
            {
                var wartosci = new List<string>();
                foreach(var w in Parametry.WartoscCechyTowaru)
                    wartosci.Add(w.Value.ToString());

                string[] wartosciTable = wartosci.ToArray();

                foreach (DokumentHandlowy dokument in rows)
                {
                    if (dokument.Anulowany) continue;
                    if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
                    if (dokument.Definicja.DuplikatWartosci) continue;
                    foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje)
                    {


                        if (pozycja.StatusPozycji == StatusPozycji.Anulowana)
                            continue;

                        bool jestZgodnaWartosc = false;
                        foreach (string wart in wartosciTable)
                        {
                            if (!string.IsNullOrEmpty(wart.Trim()) && wart.Trim() == pozycja.Towar.Features[Parametry.CechaTowaru].ToString())
                            {
                                jestZgodnaWartosc = true;
                                break;
                            }
                        }

                        if (!jestZgodnaWartosc)
                        {
                            continue;
                        }

                        Total t = (Total)result[pozycja.Towar];
                        if (t == null)
                        {
                            t = new Total(pozycja.Towar);
                            result.Add(pozycja.Towar, t);
                        }
                        t.Add(pozycja);
                    }
                }
            }

            ArrayList lista = new ArrayList(result.Values);            
            lista.Sort(new TowarComparer(parametry.SortujWedług));                                    
            Grid.DataSource = lista;
        }
        
    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="Form1" method="post" runat="server" action="#">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Raport sprzedaży wg towarów" runat="server">
        </eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            GroupData0="CechaTowaru" DataMember="Total"
            ShowGroupSum="true">
            <Columns>
                
                <ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server" EncodeHTML="True">
                </ea:GridColumn>
                
                <ea:GridColumn ID="GridColumn2" Align="Left" DataMember="Towar.Nazwa" Caption="Towar" EncodeHTML="True" runat="server">
                </ea:GridColumn>
                
                <ea:GridColumn ID="GridColumn3" Width="13" Align="Right" Caption="Kod" DataMember="Towar.Kod" runat="server">
                </ea:GridColumn>
                
                <ea:GridColumn ID="GridColumn7" Width="13" Align="Right" Caption="Ilość" DataMember="Ilosc" runat="server">
                </ea:GridColumn>                

                <ea:GridColumn ID="GridColumn8" Width="13" Align="Right" Caption="Marża" DataMember="Marza" runat="server">
                </ea:GridColumn>      
                                
                <ea:GridColumn ID="GridColumn4" Width="13" Align="Right" DataMember="Netto" Total="Sum" Format="{0:n}" runat="server">
                </ea:GridColumn>
                
                <ea:GridColumn ID="GridColumn5" Width="13" Align="Right" DataMember="VAT" Total="Sum" Format="{0:n}" runat="server">
                </ea:GridColumn>
                
                <ea:GridColumn ID="GridColumn6" Width="13" Align="Right" DataMember="Brutto" Total="Sum" Format="{0:n}" runat="server">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

